#include "vecteur.h"
#include <math.h>

Vecteur Vecteur::makeVect(float x,float y,float z)
{
 Vecteur res(x,y,z);
 return res;
}

Vecteur::Vecteur()
{
 x=y=z=0.0;
}

Vecteur::Vecteur(Vecteur &v)
{
 x=v.x;
 y=v.y;
 z=v.z;
}

Vecteur::Vecteur(float x,float y,float z)
{
 this->x=x;
 this->y=y;
 this->z=z;
}

Vecteur &Vecteur::operator=(Vecteur &v)
{
 x=v.x;
 y=v.y;
 z=v.z;
}

Vecteur Vecteur::operator+(Vecteur &v)
{
 Vecteur res(x+v.x,y+v.y,z+v.z);
 return res;
}

Vecteur Vecteur::operator-(Vecteur &v)
{
 Vecteur res(x-v.x,y-v.y,z-v.z);
 return res;
}

void Vecteur::inverse()
{
 x=-x;
 y=-y;
 z=-z;
}

Vecteur &Vecteur::operator+=(Vecteur &v)
{
 x+=v.x;
 y+=v.y;
 z+=v.z;
 return *this;
}

Vecteur &Vecteur::operator-=(Vecteur &v)
{
 x-=v.x;
 y-=v.y;
 z-=v.z;
 return *this;
}

Vecteur &Vecteur::operator*=(float a)
{
 x*=a;y*=a;z*=a;
}

Vecteur &Vecteur::operator/=(float a)
{
 x/=a;y/=a;z/=a;
}

/*
Vecteur Vecteur::operator-()
{
 Vecteur res(-x,-y,-z);
 return res;
}
*/

float Vecteur::operator*(Vecteur &v)
{
 return (x*v.x+y*v.y+z*v.z);
}

float Vecteur::length()
{
 return sqrtf(x*x+y*y+z*z);
}

float Vecteur::length2()
{
 return (x*x+y*y+z*z);
}

void Vecteur::normalize()
{
 float l=length();
 if(l>0.0)
 {
  x/=l;
  y/=l;
  z/=l;
 }
}

void Vecteur::cross(Vecteur &v)
{
 float tx,ty,tz;
 tx=(y*v.z)-(z*v.y);
 ty=(z*v.x)-(x*v.z);
 tz=(x*v.y)-(y*v.x);
 x=tx;y=ty;z=tz;
}
